/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import com.google.common.base.Predicate;
import java.awt.Point;
import java.awt.Polygon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.TreeMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityEnderPearl;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import noppes.npcs.api.INbt;
import noppes.npcs.api.IPos;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.event.ForgeEvent;
import noppes.npcs.api.handler.data.IAvailability;
import noppes.npcs.api.handler.data.IBorder;
import noppes.npcs.api.util.IRayTraceRotate;
import noppes.npcs.api.util.IRayTraceVec;
import noppes.npcs.api.wrapper.BlockPosWrapper;
import noppes.npcs.controllers.BorderController;
import noppes.npcs.controllers.data.Availability;
import noppes.npcs.util.Util;
import noppes.npcs.util.ValueUtil;

public class Zone3D
implements IBorder,
Predicate<Entity> {
    private int id = -1;
    public String name = "Default Region";
    public final TreeMap<Integer, Point> points = new TreeMap();
    public int[] y = new int[]{0, 255};
    public int dimensionID = 0;
    public int color;
    public Availability availability;
    public String message = "availability.areaNotAvailable";
    private final List<Entity> entitiesWithinRegion = new ArrayList<Entity>();
    private final Map<Entity, AntiLagTime> playerAntiLag = new HashMap<Entity, AntiLagTime>();
    public IPos homePos;
    public boolean keepOut = false;
    public boolean showInClient = false;
    public NBTTagCompound addData = new NBTTagCompound();
    private boolean update = true;

    public Zone3D() {
        this.color = new Random().nextInt(0xFFFFFF);
        this.availability = new Availability();
    }

    public Zone3D(int id, int dimID, int posX, int posY, int posZ) {
        this();
        this.id = id;
        this.dimensionID = dimID;
        this.y[0] = ValueUtil.correctInt(posY - 1, 0, 255);
        this.y[1] = ValueUtil.correctInt(posY + 4, 0, 255);
        this.points.put(0, new Point(posX, posZ - 4));
        this.points.put(1, new Point(posX + 4, posZ + 2));
        this.points.put(2, new Point(posX - 4, posZ + 2));
        this.update = true;
    }

    public Point addPoint(BlockPos position) {
        return this.addPoint(position.func_177958_n(), position.func_177956_o(), position.func_177952_p());
    }

    @Override
    public Point addPoint(int x, int y, int z) {
        Point point = new Point();
        point.x = x;
        point.y = z;
        return this.addPoint(point, y);
    }

    @Override
    public Point addPoint(IPos position) {
        return this.addPoint(position.getMCBlockPos());
    }

    @Override
    public Point addPoint(Point point, int posY) {
        for (Point p : this.points.values()) {
            if (p.x != point.x || p.y != point.y) continue;
            return null;
        }
        this.points.put(this.points.size(), point);
        posY = ValueUtil.correctInt(posY, 0, 255);
        if (posY < this.y[0]) {
            this.y[0] = posY;
        } else if (posY > this.y[1]) {
            this.y[1] = posY;
        }
        this.update = true;
        return point;
    }

    public boolean apply(Entity entity) {
        if (entity == null || entity.field_70128_L) {
            return false;
        }
        return this.contains(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70131_O);
    }

    public void centerOffsetTo(BlockPos position, boolean type) {
        this.centerOffsetTo(position.func_177958_n(), position.func_177956_o(), position.func_177952_p(), type);
    }

    @Override
    public void centerOffsetTo(int posX, int posY, int posZ, boolean type) {
        IPos ctr;
        int ry = (this.y[1] - this.y[0]) / 2;
        if (type) {
            ctr = this.getCenter();
            this.y[0] = posY - ry;
            this.y[1] = posY + ry;
        } else {
            ctr = Objects.requireNonNull(NpcAPI.Instance()).getIPos(this.getMinX(), this.y[0], this.getMinZ());
            this.y[0] = posY;
            this.y[1] = posY + ry * 2;
        }
        for (int key : this.points.keySet()) {
            Point p = this.points.get(key);
            this.points.get(key).move(posX + p.x - (int)ctr.getX(), posZ + p.y - (int)ctr.getZ());
        }
        this.update = true;
    }

    @Override
    public void centerOffsetTo(IPos position, boolean type) {
        this.centerOffsetTo(position.getMCBlockPos(), type);
    }

    @Override
    public void centerOffsetTo(Point point, boolean type) {
        this.centerOffsetTo(point.x, (this.y[0] + this.y[1]) / 2, point.y, type);
    }

    @Override
    public void clear() {
        this.points.clear();
        this.availability.clear();
        this.playerAntiLag.clear();
        this.entitiesWithinRegion.clear();
        this.y[0] = 255;
        this.y[1] = 0;
        this.message = "availability.areaNotAvailable";
        this.keepOut = false;
        this.showInClient = false;
        this.update = true;
    }

    public boolean contains(Entity entity) {
        return entity.field_70170_p.field_73011_w.getDimension() == this.dimensionID && this.contains(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70131_O);
    }

    @Override
    public boolean contains(IEntity<?> entity) {
        return entity.getWorld().getDimension().getId() == this.dimensionID && this.contains(entity.getX(), entity.getY(), entity.getZ(), entity.getHeight());
    }

    @Override
    public boolean contains(double posX, double posY, double posZ, double height) {
        if (posY + height < (double)this.y[0] || posY - height > (double)this.y[1]) {
            return false;
        }
        int dx = (int)(posX * 10.0);
        int dz = (int)(posZ * 10.0);
        Polygon poly = new Polygon();
        boolean isIn = false;
        for (Point p : this.points.values()) {
            int px = 5 + p.x * 10;
            int py = 5 + p.y * 10;
            poly.addPoint(px, py);
            isIn = px == dx && py == dz;
            if (!isIn) continue;
            break;
        }
        if (isIn) {
            return true;
        }
        isIn = poly.contains(dx, dz);
        return isIn;
    }

    @Override
    public boolean contains(int posX, int posZ) {
        for (Point p : this.points.values()) {
            if (p.x != posX || p.y != posZ) continue;
            return true;
        }
        return false;
    }

    @Override
    public double distanceTo(double posX, double posZ) {
        IPos pos = this.getCenter();
        return Util.instance.distanceTo(pos.getX() + 0.5, 0.0, pos.getZ() + 0.5, posX, 0.0, posZ);
    }

    public double distanceTo(Entity entity) {
        if (entity == null) {
            return -1.0;
        }
        IPos c = this.getCenter();
        return Util.instance.distanceTo(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, c.getX() + 0.5, c.getY() + 0.5, c.getZ() + 0.5);
    }

    @Override
    public double distanceTo(IEntity<?> entity) {
        return this.distanceTo((Entity)entity.getMCEntity());
    }

    public boolean equals(Zone3D zone) {
        if (zone == null) {
            return false;
        }
        if (zone.y[0] != this.y[0] || zone.y[1] != this.y[1]) {
            return false;
        }
        if (zone.points.size() != this.points.size()) {
            return false;
        }
        for (int key : zone.points.keySet()) {
            if (!this.points.containsKey(key)) {
                return false;
            }
            Point p0 = zone.points.get(key);
            Point p1 = this.points.get(key);
            if (p0.x == p1.x && p0.y == p1.y) continue;
            return false;
        }
        return true;
    }

    public void fix() {
        TreeMap<Integer, Point> newPoints = new TreeMap<Integer, Point>();
        int i = 0;
        boolean needChange = false;
        for (int pos : this.points.keySet()) {
            newPoints.put(i, this.points.get(pos));
            if (i != pos) {
                needChange = true;
            }
            ++i;
        }
        if (needChange) {
            this.points.clear();
            this.points.putAll(newPoints);
        }
        this.getHomePos();
    }

    @Override
    public IAvailability getAvailability() {
        return this.availability;
    }

    @Override
    public IPos getCenter() {
        double x = 0.0;
        double z = 0.0;
        for (Point v : this.points.values()) {
            x += (double)v.x;
            z += (double)v.y;
        }
        if (!this.points.isEmpty()) {
            x /= (double)this.points.size();
            z /= (double)this.points.size();
        }
        return new BlockPosWrapper(x, (double)this.y[0] + ((double)this.y[1] - (double)this.y[0]) / 2.0, z);
    }

    @Override
    public int getClosestPoint(Point point, IPos pos) {
        double d3;
        double d2;
        double d1;
        if (this.points.isEmpty()) {
            return -1;
        }
        if (this.points.size() == 1) {
            return 0;
        }
        int n = 0;
        Point entPoint = new Point((int)pos.getX(), (int)pos.getZ());
        double dm0 = this.points.get(0).distance(point);
        double dm1 = this.points.get(1).distance(point);
        double dm2 = this.points.get(0).distance(entPoint);
        double dm3 = this.points.get(1).distance(entPoint);
        int p = 0;
        while (p + 1 < this.points.size()) {
            double d32;
            double d22;
            double d12;
            double d0 = this.points.get(p).distance(point);
            if (dm0 + dm1 + dm2 + dm3 > d0 + (d12 = this.points.get(p + 1).distance(point)) + (d22 = this.points.get(p).distance(entPoint)) + (d32 = this.points.get(p + 1).distance(entPoint))) {
                dm0 = d0;
                dm1 = d12;
                dm2 = d22;
                dm3 = d32;
                n = p;
            }
            ++p;
        }
        double d0 = this.points.get(0).distance(point);
        if (dm0 + dm1 + dm2 + dm3 > d0 + (d1 = this.points.get(this.points.size() - 1).distance(point)) + (d2 = this.points.get(0).distance(entPoint)) + (d3 = this.points.get(this.points.size() - 1).distance(entPoint))) {
            n = this.points.size() - 1;
        }
        return n;
    }

    @Override
    public Point[] getClosestPoints(Point point, IPos pos) {
        Point[] ps = new Point[]{null, null};
        int n = this.getClosestPoint(point, pos);
        if (this.points.containsKey(n)) {
            ps[0] = this.points.get(n);
        }
        if (this.points.containsKey(n + 1)) {
            ps[1] = this.points.get(n + 1);
        } else if (n == this.points.size() - 1) {
            ps[1] = this.points.get(0);
        }
        return ps;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public int getDimensionId() {
        return this.dimensionID;
    }

    public int getHeight() {
        return this.y[1] - this.y[0];
    }

    @Override
    public IPos getHomePos() {
        if (this.homePos == null || this.keepOut != this.contains(this.homePos.getX() + 0.5, this.homePos.getY() + 0.5, this.homePos.getZ() + 0.5, 0.0)) {
            this.homePos = this.getCenter();
            if (this.keepOut && !this.points.isEmpty()) {
                for (int i = 0; i < 4; ++i) {
                    int x = this.points.get((Object)Integer.valueOf((int)0)).x;
                    int z = this.points.get((Object)Integer.valueOf((int)0)).y;
                    switch (i) {
                        case 1: {
                            --x;
                            break;
                        }
                        case 2: {
                            ++z;
                            break;
                        }
                        case 3: {
                            --z;
                            break;
                        }
                        default: {
                            ++x;
                        }
                    }
                    if (this.contains(x, z)) continue;
                    this.homePos = Objects.requireNonNull(NpcAPI.Instance()).getIPos(x, (double)this.y[0] + (double)(this.y[1] - this.y[0]) / 2.0, z);
                }
            }
        }
        return this.homePos;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public int getIdNearestPoint(BlockPos pos) {
        if (this.points.isEmpty() || pos == null) {
            return -1;
        }
        double min = Double.MAX_VALUE;
        int id = -1;
        for (int i : this.points.keySet()) {
            double dist = Util.instance.distanceTo(this.points.get((Object)Integer.valueOf((int)i)).x, 0.0, this.points.get((Object)Integer.valueOf((int)i)).y, pos.func_177958_n(), 0.0, pos.func_177952_p());
            if (!(dist <= min)) continue;
            min = dist;
            id = i;
        }
        return id;
    }

    @Override
    public int getMaxX() {
        if (this.points.isEmpty()) {
            return 0;
        }
        int value = this.points.get((Object)Integer.valueOf((int)0)).x;
        for (Point v : this.points.values()) {
            if (value >= v.x) continue;
            value = v.x;
        }
        return value;
    }

    @Override
    public int getMaxY() {
        return Math.max(this.y[0], this.y[1]);
    }

    @Override
    public int getMaxZ() {
        if (this.points.isEmpty()) {
            return 0;
        }
        int value = this.points.get((Object)Integer.valueOf((int)0)).y;
        for (Point v : this.points.values()) {
            if (value >= v.y) continue;
            value = v.y;
        }
        return value;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public int getMinX() {
        if (this.points.isEmpty()) {
            return 0;
        }
        int value = this.points.get((Object)Integer.valueOf((int)0)).x;
        for (Point v : this.points.values()) {
            if (value <= v.x) continue;
            value = v.x;
        }
        return value;
    }

    @Override
    public int getMinY() {
        return Math.min(this.y[0], this.y[1]);
    }

    @Override
    public int getMinZ() {
        if (this.points.isEmpty()) {
            return 0;
        }
        int value = this.points.get((Object)Integer.valueOf((int)0)).y;
        for (Point v : this.points.values()) {
            if (value <= v.y) continue;
            value = v.y;
        }
        return value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public INbt getNbt() {
        NBTTagCompound nbtRegion = new NBTTagCompound();
        this.load(nbtRegion);
        return Objects.requireNonNull(NpcAPI.Instance()).getINbt(nbtRegion);
    }

    @Override
    public Point[] getPoints() {
        return this.points.values().toArray(new Point[0]);
    }

    public String getSize() {
        return this.getMaxX() - this.getMinX() + "x" + this.getHeight() + "x" + (this.getMaxZ() - this.getMinZ());
    }

    @Override
    public boolean insertPoint(int posX, int posY, int posZ, IPos pos) {
        Point p = new Point();
        p.x = posX;
        p.y = posZ;
        return this.insertPoint(p, posY, pos);
    }

    @Override
    public boolean insertPoint(IPos pos0, IPos pos1) {
        return this.insertPoint((int)pos0.getX(), (int)pos0.getY(), (int)pos0.getZ(), pos1);
    }

    @Override
    public boolean insertPoint(Point point, int posY, IPos pos) {
        if ((posY = ValueUtil.correctInt(posY, 0, 255)) < this.y[0]) {
            this.y[0] = posY;
        }
        if (posY > this.y[1]) {
            this.y[1] = posY;
        }
        if (this.contains(point.x, point.y)) {
            return false;
        }
        if (this.points.size() < 2) {
            return this.addPoint(point, posY) != null;
        }
        int n = this.getClosestPoint(point, pos);
        TreeMap<Integer, Point> newPoints = new TreeMap<Integer, Point>();
        int j = 0;
        for (int i = 0; i < this.points.size(); ++i) {
            newPoints.put(i + j, this.points.get(i));
            if (i != n) continue;
            j = 1;
            newPoints.put(i + j, point);
        }
        if (newPoints.size() != this.points.size()) {
            this.points.clear();
            this.points.putAll(newPoints);
            this.update = true;
        }
        return this.update;
    }

    @Override
    public boolean isShowToPlayers() {
        return this.showInClient;
    }

    private EntityPlayerMP convertToPlayer(Entity entity) {
        if (entity instanceof EntityPlayerMP) {
            return (EntityPlayerMP)entity;
        }
        if (entity instanceof EntityEnderPearl && ((EntityEnderPearl)entity).func_85052_h() instanceof EntityPlayerMP) {
            return (EntityPlayerMP)((EntityEnderPearl)entity).func_85052_h();
        }
        return null;
    }

    public void offset(BlockPos position) {
        this.offset(position.func_177958_n(), position.func_177956_o(), position.func_177952_p());
    }

    @Override
    public void offset(int posX, int posY, int posZ) {
        this.y[0] = ValueUtil.correctInt(this.y[0] + posY, 0, 255);
        this.y[1] = ValueUtil.correctInt(this.y[1] + posY, 0, 255);
        for (int key : this.points.keySet()) {
            Point p = this.points.get(key);
            this.points.get(key).move(p.x + posX, p.y + posZ);
        }
        this.update = true;
    }

    @Override
    public void offset(IPos position) {
        this.offset(position.getMCBlockPos());
    }

    @Override
    public void offset(Point point) {
        this.offset(point.x, 0, point.y);
    }

    public void load(NBTTagCompound nbtRegion) {
        this.id = nbtRegion.func_74762_e("ID");
        this.name = nbtRegion.func_74779_i("Name");
        this.dimensionID = nbtRegion.func_74762_e("DimensionID");
        this.color = nbtRegion.func_74762_e("Color");
        int[] sy = nbtRegion.func_74759_k("AxisY");
        if (sy.length > 0) {
            this.y[0] = ValueUtil.correctInt(sy[0], 0, 255);
        }
        if (sy.length > 1) {
            this.y[1] = ValueUtil.correctInt(sy[1], 0, 255);
        }
        this.points.clear();
        for (int i = 0; i < nbtRegion.func_150295_c("Points", 11).func_74745_c(); ++i) {
            int[] p = nbtRegion.func_150295_c("Points", 11).func_150306_c(i);
            this.points.put(i, new Point(p[0], p[1]));
        }
        this.availability.load(nbtRegion.func_74775_l("Availability"));
        this.message = nbtRegion.func_74779_i("Message");
        if (nbtRegion.func_150297_b("HomePos", 4)) {
            BlockPos pos = BlockPos.func_177969_a((long)nbtRegion.func_74763_f("HomePos"));
            this.setHomePos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        } else if (nbtRegion.func_150297_b("HomePos", 11)) {
            int[] pos = nbtRegion.func_74759_k("HomePos");
            this.setHomePos(pos[0], pos[1], pos[2]);
        }
        this.keepOut = nbtRegion.func_74767_n("IsKeepOut");
        this.showInClient = nbtRegion.func_74767_n("ShowInClient");
        this.addData = nbtRegion.func_74775_l("AddData");
        this.fix();
        this.update = false;
        this.entitiesWithinRegion.clear();
    }

    @Override
    public boolean removePoint(int x, int z) {
        if (this.points.size() <= 1) {
            return false;
        }
        for (int key : this.points.keySet()) {
            if (this.points.get((Object)Integer.valueOf((int)key)).x != x || this.points.get((Object)Integer.valueOf((int)key)).y != z) continue;
            this.points.remove(key);
            this.fix();
            this.update = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean removePoint(Point point) {
        if (point == null || this.points.size() <= 1) {
            return false;
        }
        return this.removePoint(point.x, point.y);
    }

    @Override
    public void scaling(double radius, boolean type) {
        if (this.points.isEmpty()) {
            return;
        }
        this.y[0] = ValueUtil.correctInt(this.y[0] - (int)radius, 0, 255);
        this.y[1] = ValueUtil.correctInt(this.y[0] + (int)radius, 0, 255);
        IPos pos = type ? this.getCenter() : Objects.requireNonNull(NpcAPI.Instance()).getIPos(this.getMinX(), this.y[0], this.getMinZ());
        for (int id : this.points.keySet()) {
            Point v = this.points.get(id);
            IRayTraceRotate d = Util.instance.getAngles3D(pos.getX(), 0.0, pos.getZ(), v.x, 0.0, v.y);
            IRayTraceVec p = Util.instance.getPosition(pos.getX(), 0.0, pos.getZ(), d.getYaw(), d.getPitch(), radius + d.getRadiusXZ());
            this.points.put(id, new Point((int)p.getX(), (int)p.getZ()));
        }
        this.update = true;
    }

    @Override
    public void scaling(float scale, boolean type) {
        if (this.points.isEmpty()) {
            return;
        }
        IPos pos = type ? this.getCenter() : Objects.requireNonNull(NpcAPI.Instance()).getIPos(this.getMinX(), this.y[0], this.getMinZ());
        for (int key : this.points.keySet()) {
            Point v = this.points.get(key);
            IRayTraceRotate d = Util.instance.getAngles3D(pos.getX(), pos.getY(), pos.getZ(), v.x, pos.getY(), v.y);
            IRayTraceVec p = Util.instance.getPosition(pos.getX(), pos.getY(), pos.getZ(), d.getYaw(), d.getPitch(), (double)scale * d.getRadiusXZ());
            this.points.put(key, new Point((int)p.getX(), (int)p.getZ()));
            if (this.y[0] > (int)p.getY()) {
                this.y[0] = ValueUtil.correctInt((int)p.getY(), 0, 255);
            }
            if (this.y[1] >= (int)p.getY()) continue;
            this.y[1] = ValueUtil.correctInt((int)p.getY(), 0, 255);
        }
        this.update = true;
    }

    @Override
    public void setColor(int color) {
        this.color = color;
        this.update = true;
    }

    @Override
    public void setDimensionId(int dimID) {
        this.dimensionID = dimID;
        this.update = true;
    }

    @Override
    public void setHomePos(int x, int y, int z) {
        if (this.homePos == null || this.keepOut != this.contains((double)x + 0.5, y, (double)z + 0.5, 0.0)) {
            return;
        }
        this.homePos = Objects.requireNonNull(NpcAPI.Instance()).getIPos(x, y, z);
        this.update = true;
    }

    @Override
    public void setMessage(String message) {
        this.message = message == null ? "" : message;
        this.update = true;
    }

    @Override
    public void setName(String name) {
        if (name == null || name.isEmpty()) {
            name = "Default Region";
        }
        this.name = name;
        this.update = true;
    }

    @Override
    public void setNbt(INbt nbt) {
        this.save(nbt.getMCNBT());
        this.update = true;
    }

    public Point setPoint(int index, BlockPos position) {
        return this.setPoint(index, position.func_177958_n(), position.func_177956_o(), position.func_177952_p());
    }

    @Override
    public Point setPoint(int index, int x, int y, int z) {
        Point point = new Point();
        point.x = x;
        point.y = z;
        this.update = true;
        return this.setPoint(index, point, y);
    }

    @Override
    public Point setPoint(int index, IPos position) {
        return this.setPoint(index, position.getMCBlockPos());
    }

    @Override
    public Point setPoint(int index, Point point) {
        if (!this.points.containsKey(index) || index > this.points.size()) {
            return null;
        }
        this.points.put(index, point);
        this.update = true;
        return point;
    }

    @Override
    public Point setPoint(int index, Point point, int posY) {
        if (!this.points.containsKey(index) || index > this.points.size()) {
            return null;
        }
        this.points.put(index, point);
        posY = ValueUtil.correctInt(posY, 0, 255);
        if (posY < this.y[0]) {
            this.y[0] = posY;
        }
        if (posY > this.y[1]) {
            this.y[1] = posY;
        }
        this.update = true;
        return point;
    }

    @Override
    public void setShowToPlayers(boolean show) {
        this.showInClient = show;
        this.update = true;
    }

    @Override
    public int size() {
        return this.points.size();
    }

    public String toString() {
        return "ID:" + this.id + "; name: \"" + this.name + "\"";
    }

    @Override
    public void update() {
        this.update = true;
    }

    public void update(WorldServer world) {
        if (this.update) {
            this.entitiesWithinRegion.clear();
            this.playerAntiLag.clear();
            BorderController.getInstance().update(this.id);
            this.update = false;
            return;
        }
        if (this.points.isEmpty() || this.dimensionID != world.field_73011_w.getDimension()) {
            return;
        }
        List entities = new ArrayList();
        try {
            entities = world.func_175647_a(Entity.class, this.getAxisAlignedBB().func_186662_g(1.0), (Predicate)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Entity entity : entities) {
            if (this.entitiesWithinRegion.contains(entity) || this.tryEntityEnter(entity)) continue;
            this.entitiesWithinRegion.add(entity);
            MinecraftForge.EVENT_BUS.post((Event)new ForgeEvent.EnterToRegion(entity, this));
        }
        ArrayList<Entity> del = new ArrayList<Entity>();
        for (Entity entity : this.entitiesWithinRegion) {
            if (!this.tryEntityLeave(entity, this.contains(entity))) continue;
            del.add(entity);
        }
        for (Entity entity : del) {
            this.entitiesWithinRegion.remove(entity);
            this.playerAntiLag.remove(entity);
            MinecraftForge.EVENT_BUS.post((Event)new ForgeEvent.LeaveRegion(entity, this));
        }
    }

    private boolean tryEntityEnter(Entity entity) {
        EntityPlayerMP player = this.convertToPlayer(entity);
        if (player == null || this.availability.isAvailable((EntityPlayer)player) || player.field_71075_bZ.field_75098_d) {
            return false;
        }
        if (!this.keepOut) {
            return false;
        }
        IPos center = this.getCenter();
        this.motionPlayer(player, new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v).func_178788_d(new Vec3d(center.getX(), center.getY(), center.getZ())).func_72432_b());
        if (entity instanceof EntityEnderPearl) {
            entity.field_70128_L = true;
        }
        return true;
    }

    private boolean tryEntityLeave(Entity entity, boolean isContains) {
        EntityPlayerMP player = this.convertToPlayer(entity);
        if (player == null || this.availability.isAvailable((EntityPlayer)player) || player.field_71075_bZ.field_75098_d) {
            return !isContains;
        }
        if (!this.keepOut && isContains) {
            return false;
        }
        IPos center = this.getCenter();
        this.motionPlayer(player, new Vec3d(center.getX(), center.getY(), center.getZ()).func_178788_d(new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v)).func_72432_b());
        if (entity instanceof EntityEnderPearl) {
            entity.field_70128_L = true;
        }
        return false;
    }

    private void motionPlayer(EntityPlayerMP player, Vec3d vec) {
        double corrector = 0.25;
        player.field_70159_w = vec.field_72450_a * corrector;
        player.field_70181_x = vec.field_72448_b * corrector;
        player.field_70179_y = vec.field_72449_c * corrector;
        player.field_70133_I = true;
        if (!this.message.isEmpty()) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation(this.message, new Object[0]), true);
        }
        if (!this.playerAntiLag.containsKey(player)) {
            this.playerAntiLag.put((Entity)player, new AntiLagTime(this.keepOut ? this.homePos.getMCBlockPos() : player.func_180425_c()));
        }
        if (this.playerAntiLag.get(player).isLag(player.func_180425_c())) {
            this.playerAntiLag.get(player).clear(player.func_180425_c());
            player.func_70634_a(this.homePos.getX() + 0.5, this.homePos.getY(), this.homePos.getZ() + 0.5);
        }
    }

    public void save(NBTTagCompound nbtRegion) {
        nbtRegion.func_74768_a("ID", this.id);
        nbtRegion.func_74778_a("Name", this.name);
        nbtRegion.func_74768_a("DimensionID", this.dimensionID);
        nbtRegion.func_74768_a("Color", this.color);
        NBTTagList ps = new NBTTagList();
        for (int pos : this.points.keySet()) {
            ps.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{this.points.get((Object)Integer.valueOf((int)pos)).x, this.points.get((Object)Integer.valueOf((int)pos)).y}));
        }
        nbtRegion.func_74782_a("Points", (NBTBase)ps);
        nbtRegion.func_74783_a("AxisY", this.y);
        nbtRegion.func_74782_a("Availability", (NBTBase)this.availability.save(new NBTTagCompound()));
        nbtRegion.func_74778_a("Message", this.message);
        nbtRegion.func_74772_a("HomePos", this.homePos.getMCBlockPos().func_177986_g());
        nbtRegion.func_74757_a("IsKeepOut", this.keepOut);
        nbtRegion.func_74757_a("ShowInClient", this.showInClient);
        nbtRegion.func_74782_a("AddData", (NBTBase)this.addData);
        this.fix();
    }

    public AxisAlignedBB getAxisAlignedBB() {
        return new AxisAlignedBB((5.0 + (double)this.getMinX() * 10.0) / 10.0, (5.0 + (double)this.getMinY() * 10.0) / 10.0, (5.0 + (double)this.getMinZ() * 10.0) / 10.0, (5.0 + (double)this.getMaxX() * 10.0) / 10.0, (5.0 + (double)this.getMaxY() * 10.0) / 10.0, (5.0 + (double)this.getMaxZ() * 10.0) / 10.0);
    }

    @Override
    public Vec3d intersectsWithLine(Vec3d startPos, Vec3d endPos) {
        double baseY = this.getMinY();
        double height = (double)this.getMaxY() - baseY;
        ArrayList<Vec3d> vertices = new ArrayList<Vec3d>();
        for (Point point : this.points.values()) {
            vertices.add(new Vec3d((double)point.x, baseY, (double)point.y));
        }
        List<Vec3d> topVertices = this.createOffsetVertices(vertices, height);
        Vec3d topResult = Zone3D.checkIntersection(startPos, endPos, topVertices, baseY);
        Vec3d bottomResult = Zone3D.checkIntersection(startPos, endPos, vertices, baseY);
        Vec3d wallResult = null;
        for (int i = 0; i < vertices.size(); ++i) {
            Vec3d v1 = (Vec3d)vertices.get(i);
            Vec3d v2 = (Vec3d)vertices.get((i + 1) % vertices.size());
            Vec3d topV1 = new Vec3d(v1.field_72450_a, v1.field_72448_b + height, v1.field_72449_c);
            Vec3d topV2 = new Vec3d(v2.field_72450_a, v2.field_72448_b + height, v2.field_72449_c);
            wallResult = this.checkSegmentIntersection(startPos, endPos, v1, v2);
            if (wallResult != null || (wallResult = this.checkSegmentIntersection(startPos, endPos, topV1, topV2)) != null) break;
        }
        if (wallResult != null) {
            if (topResult == null && bottomResult == null) {
                return wallResult;
            }
            double topDist = Double.MAX_VALUE;
            double bottomDist = Double.MAX_VALUE;
            double wallDist = startPos.func_72438_d(wallResult);
            if (topResult != null) {
                topDist = startPos.func_72438_d(topResult);
            }
            if (bottomResult != null) {
                bottomDist = startPos.func_72438_d(bottomResult);
            }
            if (topDist < wallDist) {
                return topDist < bottomDist ? topResult : bottomResult;
            }
            return bottomDist < wallDist ? bottomResult : wallResult;
        }
        if (topResult == null) {
            return bottomResult;
        }
        return topResult;
    }

    private List<Vec3d> createOffsetVertices(List<Vec3d> originalVertices, double offset) {
        ArrayList<Vec3d> offsetVertices = new ArrayList<Vec3d>();
        for (Vec3d vertex : originalVertices) {
            offsetVertices.add(new Vec3d(vertex.field_72450_a, vertex.field_72448_b + offset, vertex.field_72449_c));
        }
        return offsetVertices;
    }

    private static Vec3d checkIntersection(Vec3d start, Vec3d end, List<Vec3d> polygon, double baseY) {
        int crossings = 0;
        int i = 0;
        int j = polygon.size() - 1;
        while (i < polygon.size()) {
            Vec3d edgeStart = polygon.get(i);
            Vec3d edgeEnd = polygon.get(j);
            if (edgeStart.field_72448_b > start.field_72448_b != edgeEnd.field_72448_b > start.field_72448_b && start.field_72450_a < (edgeEnd.field_72450_a - edgeStart.field_72450_a) * (start.field_72448_b - edgeStart.field_72448_b) / (edgeEnd.field_72448_b - edgeStart.field_72448_b) + edgeStart.field_72450_a) {
                ++crossings;
            }
            j = i++;
        }
        return crossings % 2 == 1 ? new Vec3d((end.field_72450_a - start.field_72450_a) / (end.field_72448_b - start.field_72448_b) * (baseY - start.field_72448_b) + start.field_72450_a, baseY, (end.field_72449_c - start.field_72449_c) / (end.field_72448_b - start.field_72448_b) * (baseY - start.field_72448_b) + start.field_72449_c) : null;
    }

    private Vec3d checkSegmentIntersection(Vec3d startPos, Vec3d endPos, Vec3d segmentStart, Vec3d segmentEnd) {
        double denominator = (segmentEnd.field_72449_c - segmentStart.field_72449_c) * (endPos.field_72450_a - startPos.field_72450_a) - (segmentEnd.field_72450_a - segmentStart.field_72450_a) * (endPos.field_72449_c - startPos.field_72449_c);
        if (denominator == 0.0) {
            return null;
        }
        double ua = ((segmentEnd.field_72450_a - segmentStart.field_72450_a) * (startPos.field_72449_c - segmentStart.field_72449_c) - (segmentEnd.field_72449_c - segmentStart.field_72449_c) * (startPos.field_72450_a - segmentStart.field_72450_a)) / denominator;
        double ub = ((endPos.field_72450_a - startPos.field_72450_a) * (startPos.field_72449_c - segmentStart.field_72449_c) - (endPos.field_72449_c - startPos.field_72449_c) * (startPos.field_72450_a - segmentStart.field_72450_a)) / denominator;
        if (ua >= 0.0 && ua <= 1.0 && ub >= 0.0 && ub <= 1.0) {
            double x = startPos.field_72450_a + ua * (endPos.field_72450_a - startPos.field_72450_a);
            double y = startPos.field_72448_b + ua * (endPos.field_72448_b - startPos.field_72448_b);
            double z = startPos.field_72449_c + ua * (endPos.field_72449_c - startPos.field_72449_c);
            return new Vec3d(x, y, z);
        }
        return null;
    }

    private static class AntiLagTime {
        private int count = 0;
        private long time = System.currentTimeMillis();
        private BlockPos pos;

        public AntiLagTime(BlockPos blockPos) {
            this.pos = blockPos;
        }

        public void clear(BlockPos blockPos) {
            this.time = System.currentTimeMillis();
            this.count = 0;
            this.pos = blockPos;
        }

        public boolean isLag(BlockPos blockPos) {
            if (!this.pos.equals((Object)blockPos) || this.time + 3000L >= System.currentTimeMillis()) {
                this.clear(blockPos);
                return false;
            }
            ++this.count;
            return this.count > 50;
        }
    }
}

